<?php
if (!isset($_SESSION)) session_start();
require_once '../config/db.php';
$currentUser = null;
if (isset($_SESSION['user_id'])) {
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $currentUser = $stmt->fetch();
}
$userName = $currentUser['full_name'] ?? $currentUser['username'] ?? 'User';
$userAvatar = !empty($currentUser['profile_picture'])
    ? '../uploads/profiles/' . htmlspecialchars($currentUser['profile_picture'])
    : '../assets/img/default-profile.png';
$activePage = $activePage ?? '';
$sort = $_GET['sort'] ?? 'name';

$menuItems = [
    'dashboard' => [
        'icon' => 'fas fa-chart-line',
        'label' => 'Dashboard',
        'url' => 'dashboard.php'
    ],
    'pos' => [
        'icon' => 'fas fa-cash-register',
        'label' => 'Point of Sale',
        'url' => 'pos.php'
    ],
    'sales' => [
        'icon' => 'fas fa-shopping-cart',
        'label' => 'Sales',
        'url' => 'sales.php'
    ],
    'products' => [
        'icon' => 'fas fa-box',
        'label' => 'Products',
        'url' => 'products.php'
    ],
    'inventory' => [
        'icon' => 'fas fa-warehouse',
        'label' => 'Inventory',
        'url' => 'inventory.php'
    ],
    'customers' => [
        'icon' => 'fas fa-users',
        'label' => 'Customers',
        'url' => 'customers.php'
    ],
    'suppliers' => [
        'icon' => 'fas fa-truck',
        'label' => 'Suppliers',
        'url' => 'suppliers.php'
    ],
    'credit' => [
        'icon' => 'fas fa-credit-card',
        'label' => 'Credit Sales',
        'url' => 'credit.php'
    ],
    'reports' => [
        'icon' => 'fas fa-file-alt',
        'label' => 'Reports',
        'url' => 'reports.php'
    ],
    'bongapoints' => [
        'icon' => 'fas fa-star',
        'label' => 'Bonga Points',
        'url' => 'bongapoints.php'
    ],
    'settings' => [
        'icon' => 'fas fa-cog',
        'label' => 'Settings',
        'url' => 'settings.php'
    ]
];

$isSuperAdmin = false;
if (isset($currentUser['role_id'])) {
    $stmt = $pdo->prepare("SELECT is_super_admin FROM roles WHERE id = ?");
    $stmt->execute([$currentUser['role_id']]);
    $isSuperAdmin = $stmt->fetchColumn();
}
?>
<style>
/* Modern Glassmorphism Sidebar */
.sidebar-modern {
    min-height: 100vh;
    background: rgba(26, 41, 71, 0.85);
    backdrop-filter: blur(12px) saturate(180%);
    box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.18);
    color: #fff;
    border-radius: 24px 24px 24px 24px;
    padding: 0 0.5rem;
    transition: all 0.3s cubic-bezier(.4,2,.6,1);
    width: 280px;
    position: fixed;
    z-index: 1040;
    top: 0;
    left: 0;
    border: 5px solid;
    overflow-y: auto;
    height: 100vh;
}

/* Profile Section */
.profile-section {
    padding: 1.5rem 1rem;
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 0.8rem;
    border-bottom: 1px solid rgba(255,255,255,0.1);
    margin-bottom: 1rem;
    text-align: center;
}

.profile-avatar {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    object-fit: cover;
    border: 3px solid rgba(255,255,255,0.2);
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}

.profile-name {
    font-size: 1.1rem;
    font-weight: 600;
    color: #fff;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    max-width: 100%;
    padding: 0 0.5rem;
}

/* Navigation Links */
.sidebar-modern .nav-link {
    color: #bfc9da;
    font-weight: 500;
    border-radius: 12px;
    margin: 0.2rem 0.5rem;
    padding: 0.7rem 1rem;
    transition: all 0.18s ease;
    display: flex;
    align-items: center;
    gap: 0.7rem;
    font-size: 1rem;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

/* Sidebar Section Titles */
.sidebar-section-title {
    color: #64748b;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.05rem;
    margin: 0 1rem 0.1rem 1rem;
    padding: 0.1rem 0;
    border-bottom: 1px solid rgba(255,255,255,0.1);
}

/* Divider */
.divider {
    height: 1px;
    background: rgba(255,255,255,0.1);
    margin: 1rem 0.5rem;
}

.sidebar-modern .nav-link.active, 
.sidebar-modern .nav-link:hover {
    background: linear-gradient(90deg, #2563eb 0%, #1e40af 100%);
    color: #fff;
    box-shadow: 0 2px 8px 0 rgba(37,99,235,0.10);
    transform: translateX(5px);
}

.sidebar-modern .nav-link i {
    font-size: 1.2rem;
    min-width: 24px;
    text-align: center;
}

/* Mobile Responsive Styles */
@media (max-width: 991px) {
    .sidebar-modern {
        transform: translateX(-100%);
        width: 100%;
        max-width: 300px;
        border-radius: 0;
        border: none;
        box-shadow: 0 0 20px rgba(0,0,0,0.2);
        display: block !important; /* Force display on mobile */
    }
    
    .sidebar-modern.show {
        transform: translateX(0);
    }
    
    .sidebar-overlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.5);
        z-index: 1039;
        backdrop-filter: blur(3px);
    }
    
    .sidebar-overlay.show {
        display: block;
    }
    
    /* Ensure main content doesn't overlap with sidebar */
    .main-content {
        margin-left: 0 !important;
        padding-top: 70px;
    }
}

/* Small Screen Adjustments */
@media (max-width: 576px) {
    .sidebar-modern {
        max-width: 280px;
    }
    
    .sidebar-modern .nav-link {
        padding: 0.7rem 0.9rem;
        font-size: 0.95rem;
    }
    
    .sidebar-modern .nav-link i {
        font-size: 1.1rem;
    }
    
    .profile-section {
        padding: 1rem 0.6rem;
    }
    
    .profile-avatar {
        width: 60px;
        height: 60px;
    }
    
    .profile-name {
        font-size: 1rem;
    }

    /* Adjust dropdown menus for smaller screens */
    .sidebar-modern .dropdown-menu {
        padding: 0.3rem 0;
    }

    .sidebar-modern .dropdown-item {
        padding: 0.6rem 1.2rem;
        font-size: 0.9rem;
    }
}

/* Extra Small Screen Adjustments */
@media (max-width: 360px) {
    .sidebar-modern {
        max-width: 260px;
    }
    
    .sidebar-modern .nav-link {
        padding: 0.6rem 0.8rem;
        font-size: 0.9rem;
    }
    
    .profile-avatar {
        width: 50px;
        height: 50px;
    }
    
    .profile-name {
        font-size: 0.9rem;
    }
}

/* Mobile Sidebar Toggle Button Styles */
#sidebarToggleBtn {
    width: 45px;
    height: 45px;
    border-radius: 50%;
    padding: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 2px 8px rgba(0,0,0,0.2);
    border: none;
    background: #2563eb;
    color: white;
    transition: all 0.3s ease;
    position: fixed;
    top: 15px;
    left: 15px;
    z-index: 1050;
}

#sidebarToggleBtn:hover {
    background: #1d4ed8;
    transform: scale(1.05);
}

#sidebarToggleBtn i {
    font-size: 1.3rem;
}

/* Ensure smooth transitions */
.sidebar-modern,
.sidebar-overlay,
#sidebarToggleBtn {
    transition: all 0.3s ease-in-out;
}

/* Main Content Adjustment */
.main-content {
    margin-left: 280px;
    transition: margin-left 0.3s ease;
    padding: 20px;
}

@media (max-width: 991px) {
    .main-content {
        margin-left: 0;
        padding: 15px;
        padding-top: 70px;
    }
}
</style>

<!-- Sidebar Overlay -->
<div class="sidebar-overlay" id="sidebarOverlay"></div>

<!-- Mobile Sidebar Toggle Button -->
<button class="btn btn-primary d-md-none position-fixed" id="sidebarToggleBtn" style="top: 10px; left: 10px; z-index: 1050;">
    <i class="fas fa-bars"></i>
</button>

<!-- Sidebar Navigation -->
<nav class="sidebar-modern" id="sidebarModern">
    <div class="profile-section">
        <img src="<?php echo $userAvatar; ?>" class="profile-avatar" alt="User Avatar">
        <span class="profile-name"><?php echo htmlspecialchars($userName); ?></span>
    </div>
    <ul class="nav flex-column">
        <li class="nav-item mb-1">
            <a class="nav-link<?php if ($activePage == 'dashboard') echo ' active'; ?>" href="../pages/dashboard.php">
                <i class="fas fa-home"></i>Dashboard
            </a>
        </li>
        <?php if (function_exists('hasPermission') && hasPermission('create_sales')): ?>
        <li class="nav-item mb-1">
            <a class="nav-link<?php if ($activePage == 'pos') echo ' active'; ?>" href="pos.php">
                <i class="fas fa-cash-register"></i>POS
            </a>
        </li>
        <?php endif; ?>
        <?php if (function_exists('hasAnyPermission') && hasAnyPermission(['view_customers', 'manage_customers', 'add_customer', 'edit_customer', 'delete_customer'])): ?>
        <li class="nav-item mb-1">
            <a class="nav-link<?php if ($activePage == 'customers') echo ' active'; ?>" href="customers.php">
                <i class="fas fa-users"></i>Clients
            </a>
        </li>
        <?php endif; ?>
        <?php if (function_exists('hasAnyPermission') && (hasAnyPermission(['view_suppliers', 'manage_suppliers', 'add_supplier', 'edit_supplier', 'delete_supplier', 'search_suppliers']) || $isSuperAdmin)): ?>
        <li class="nav-item mb-1">
            <a class="nav-link<?php if ($activePage == 'suppliers') echo ' active'; ?>" href="suppliers.php">
                <i class="fas fa-truck"></i>Suppliers
            </a>
        </li>
        <?php endif; ?>
        <?php if (function_exists('hasAnyPermission') && hasAnyPermission(['view_products', 'view_inventory', 'manage_products', 'manage_inventory', 'add_product', 'edit_product', 'delete_product', 'add_stock', 'edit_stock', 'delete_stock'])): ?>
        <li class="nav-item mb-1">
            <a class="nav-link<?php if ($activePage == 'products') echo ' active'; ?>" href="../pages/products.php">
                <i class="fas fa-box"></i> Stock Management
            </a>
        </li>
        <?php endif; ?>
        
        <!-- Transactions Section -->
        <div class="divider"></div>
        <li class="sidebar-section-title">Transactions</li>
        <?php if (function_exists('hasPermission') && hasPermission('view_quotation')): ?>
        <li class="nav-item mb-1">
            <a class="nav-link<?php if ($activePage == 'quotation') echo ' active'; ?>" href="quotation.php">
                <i class="fas fa-file-invoice"></i>Quotation
            </a>
        </li>
        <?php endif; ?>
        <?php if (function_exists('hasPermission') && hasPermission('view_delivery')): ?>
        <li class="nav-item mb-1">
            <a class="nav-link<?php if ($activePage == 'delivery') echo ' active'; ?>" href="delivery.php">
                <i class="fas fa-truck"></i>Delivery
            </a>
        </li>
        <?php endif; ?>
        <?php if (function_exists('hasPermission') && hasPermission('view_invoice')): ?>
        <li class="nav-item mb-1">
            <a class="nav-link<?php if ($activePage == 'invoice') echo ' active'; ?>" href="invoice.php">
                <i class="fas fa-receipt"></i>Invoice
            </a>
        </li>
        <?php endif; ?>
        <?php if (function_exists('hasAnyPermission') && hasAnyPermission(['manage_credit', 'process_credit_payment', 'waive_credit', 'send_reminder', 'add_credit_item', 'allow_credit_sale'])): ?>
        <div class="divider"></div>
        <li class="sidebar-section-title">Credit Management</li>
        <li class="nav-item mb-1">
            <a class="nav-link<?php if ($activePage == 'credit') echo ' active'; ?>" href="credit.php">
                <i class="fas fa-credit-card"></i>Credit Sales
            </a>
        </li>
        <li class="nav-item mb-1">
            <a class="nav-link<?php if ($activePage == 'cleared_credit') echo ' active'; ?>" href="Cleared Credit Sales.php">
                <i class="fas fa-check-circle"></i>Cleared Credit Sale
            </a>
        </li>
        <?php endif; ?>
        <?php if (function_exists('hasPermission') && (hasPermission('view_reports') || hasPermission('export_reports'))): ?>
        <div class="divider"></div>
        <li class="sidebar-section-title">Report Management</li>
        <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle<?php if (in_array($activePage, ['reports', 'comprehensive_report'])) echo ' active'; ?>" 
               href="#" id="reportsDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                <i class="fas fa-chart-line"></i>Reports
            </a>
            <ul class="dropdown-menu" aria-labelledby="reportsDropdown" style="background: rgba(26,41,71,0.95); border: none; min-width: 210px;">
                <?php if (hasPermission('view_reports')): ?>
                <li>
                    <a class="dropdown-item nav-link<?php if ($activePage == 'reports') echo ' active'; ?>" href="reports.php">
                        <i class="fas fa-chart-bar"></i> All Reports
                    </a>
                </li>
                <?php endif; ?>
                <?php if (hasPermission('export_reports')): ?>
                <li>
                    <a class="dropdown-item nav-link<?php if ($activePage == 'comprehensive_report') echo ' active'; ?>" href="comprehensive_report.php">
                        <i class="fas fa-file-alt"></i> Comp-Report
                    </a>
                </li>
                <li>
                    <a class="dropdown-item nav-link<?php if ($activePage == 'teller_logs') echo ' active'; ?>" href="teller_logs.php">
                        <i class="fas fa-user-clock"></i> Teller Logs
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>
        <?php if (
            (function_exists('hasPermission') && hasPermission('create_qr_code')) || $isSuperAdmin
        ): ?>
        <li class="nav-item mb-1">
            <a class="nav-link<?php if ($activePage == 'qrcodes') echo ' active'; ?>" href="qrcodes.php">
                <i class="fas fa-qrcode"></i>Generate QR Codes
            </a>
        </li>
        <?php endif; ?>
        <?php if (function_exists('hasAnyPermission') && hasAnyPermission(['manage_users', 'add_user', 'edit_user', 'delete_user', 'manage_roles', 'edit_role', 'delete_role', 'manage_settings', 'view_settings', 'view_system_logs', 'manage_logs'])): ?>
        <div class="divider"></div>
        <li class="sidebar-section-title">System Administration</li>
        <?php if (hasAnyPermission(['manage_users', 'add_user', 'edit_user', 'delete_user'])): ?>
        <li class="nav-item mb-1">
            <a class="nav-link<?php if ($activePage == 'users') echo ' active'; ?>" href="users.php">
                <i class="fas fa-user-cog"></i>User Management
            </a>
        </li>
        <?php endif; ?>
        <?php if (hasPermission('manage_roles')): ?>
        <li class="nav-item mb-1">
            <a class="nav-link<?php if ($activePage == 'roles') echo ' active'; ?>" href="roles.php">
                <i class="fas fa-user-shield"></i>Role & Permissions
            </a>
        </li>
        <?php endif; ?>
        <?php if (hasAnyPermission(['manage_settings', 'view_settings'])): ?>
        <li class="nav-item mb-1">
            <a class="nav-link<?php if ($activePage == 'settings') echo ' active'; ?>" href="settings.php">
                <i class="fas fa-sliders-h"></i>System Settings
            </a>
        </li>
        <?php endif; ?>
        <?php if (hasAnyPermission(['view_system_logs', 'manage_logs'])): ?>
        <li class="nav-item mb-1">
            <a class="nav-link<?php if ($activePage == 'system_logs') echo ' active'; ?>" href="system_logs.php">
                <i class="fas fa-clipboard-list"></i>System Logs
            </a>
        </li>
        <?php endif; ?>
        <?php endif; ?>
        <div class="divider"></div>
        <li class="nav-item mb-1">
            <a class="nav-link text-danger" href="../auth/logout.php">
                <i class="fas fa-sign-out-alt"></i>Logout
            </a>
        </li>
    </ul>
</nav>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const sidebarToggleBtn = document.getElementById('sidebarToggleBtn');
    const sidebarModern = document.getElementById('sidebarModern');
    const sidebarOverlay = document.getElementById('sidebarOverlay');
    
    function toggleSidebar() {
        sidebarModern.classList.toggle('show');
        sidebarOverlay.classList.toggle('show');
        document.body.classList.toggle('sidebar-open');
    }
    
    if (sidebarToggleBtn) {
    sidebarToggleBtn.addEventListener('click', toggleSidebar);
    }
    
    if (sidebarOverlay) {
    sidebarOverlay.addEventListener('click', toggleSidebar);
    }
    
    // Close sidebar on window resize if open
    window.addEventListener('resize', function() {
        if (window.innerWidth > 991 && sidebarModern.classList.contains('show')) {
            toggleSidebar();
        }
    });

    // Close sidebar when clicking outside on mobile
    document.addEventListener('click', function(event) {
        if (window.innerWidth <= 991) {
            const isClickInsideSidebar = sidebarModern.contains(event.target);
            const isClickOnToggleBtn = sidebarToggleBtn.contains(event.target);
            
            if (!isClickInsideSidebar && !isClickOnToggleBtn && sidebarModern.classList.contains('show')) {
                toggleSidebar();
            }
        }
    });
});
</script> 